#include "StdAfx.h"
#include "IniFile.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CIniFile::CIniFile(const TCHAR* pFileName)
{
	m_strFileName	=	pFileName;
}

CIniFile::CIniFile(const CString& strFileName)
{
	m_strFileName	=	strFileName;
}

CIniFile::~CIniFile()
{
}

BOOL
CIniFile::SectionExists(const TCHAR* strSection)
{
	TCHAR	tmp[512];
	BOOL	bRet=	FALSE;

	if (0<GetPrivateProfileSection(strSection,	tmp,	512,	(LPCTSTR)m_strFileName))
		bRet	=	TRUE;
	return	bRet;
}

BOOL
CIniFile::ValueExists(const TCHAR*	strSec,	const TCHAR*	strKey)
{
	TCHAR	tmp[256];

	if (0<GetPrivateProfileString(strSec,	strKey,	NULL,	tmp,	128,	(LPCTSTR)m_strFileName))
		return	TRUE;
	else
		return	FALSE;
}

CString
CIniFile::ReadString(const TCHAR* strSection, const TCHAR* strKey, const TCHAR* Default)
{
	TCHAR	tmp[MAX_PATH];
	memset(tmp,	0,	MAX_PATH);
	GetPrivateProfileString(strSection,	strKey,	Default,	tmp,	256,	(LPCTSTR)m_strFileName);
	CString	str(tmp);
	return	str;
}

int
CIniFile::ReadInteger(const TCHAR* strSection, const TCHAR* strKey, const int Default)
{
	return	GetPrivateProfileInt(strSection,	strKey,	Default,	(LPCTSTR)m_strFileName);
}

BOOL
CIniFile::WriteString(const TCHAR* strSection, const TCHAR* strKey, const TCHAR* strVal)
{
	return	WritePrivateProfileString(strSection,	strKey,	strVal,	(LPCTSTR)m_strFileName);
}